import { StarXpandCommand } from "star-io10-web";

export class LabelSample07_For203dpi_OrderLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 60.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    2.0,
                    12.0,
                    40.0,
                    10.0,
                  ).setThickness(0.5),
                ) // 注文番号
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    44.0,
                    12.0,
                    26.0,
                    10.0,
                  ).setThickness(0.5),
                ) // 個数
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    2.0,
                    28.0,
                    20.0,
                    10.0,
                  ).setThickness(0.5),
                ) // 常温
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    26.0,
                    28.0,
                    20.0,
                    10.0,
                  ).setThickness(0.5),
                ) // 冷蔵
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    50.0,
                    28.0,
                    20.0,
                    10.0,
                  ).setThickness(0.5),
                ) // 冷凍
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    2.0,
                    44.0,
                    68.0,
                    15.0,
                  ).setThickness(0.5),
                ) // 備考欄
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(
                    72.0,
                    4.0,
                  ).setY(2.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(12.0)
                    .styleUnderLine(true)
                    .actionPrintText("剥がさずにそのまま配達して下さい\n"),
                )
                .styleHorizontalPositionTo(16.0)
                .styleVerticalPositionTo(8.0)
                .actionPrintText("注文番号")
                .styleHorizontalPositionTo(54.0)
                .actionPrintText("個数")
                .styleHorizontalPositionTo(45.0)
                .styleVerticalPositionBy(8.0)
                .actionPrintText("合計")
                .styleHorizontalPositionBy(15.0)
                .actionPrintText("袋")
                .styleHorizontalPositionTo(9.0)
                .styleVerticalPositionBy(8.0)
                .actionPrintText("常温")
                .styleHorizontalPositionBy(18.0)
                .actionPrintText("冷蔵")
                .styleHorizontalPositionBy(18.0)
                .actionPrintText("冷凍")
                .styleHorizontalPositionTo(18.0)
                .styleVerticalPositionBy(8.0)
                .actionPrintText("袋")
                .styleHorizontalPositionBy(21.0)
                .actionPrintText("袋")
                .styleHorizontalPositionBy(21.0)
                .actionPrintText("袋")
                .styleHorizontalPositionTo(4.0)
                .styleVerticalPositionBy(8.0)
                .actionPrintText("備考欄${remarks}")
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(4.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(1, 2),
                    )
                    .styleVerticalPositionTo(17.0)
                    .actionPrintText(
                      "${order_number}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        24,
                        new StarXpandCommand.Printer.TextWidthParameter().setPrintType(
                          StarXpandCommand.Printer.TextPrintType.Always,
                        ),
                      ),
                    )
                    .styleHorizontalPositionBy(12.0)
                    .actionPrintText(
                      "${total_quantity}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        9,
                        new StarXpandCommand.Printer.TextWidthParameter()
                          .setAlignment(
                            StarXpandCommand.Printer.TextAlignment.Right,
                          )
                          .setPrintType(
                            StarXpandCommand.Printer.TextPrintType.Always,
                          ),
                      ),
                    )
                    .styleHorizontalPositionTo(4.0)
                    .styleVerticalPositionBy(16.0)
                    .actionPrintText(
                      "${room_temperature}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        9,
                        new StarXpandCommand.Printer.TextWidthParameter()
                          .setAlignment(
                            StarXpandCommand.Printer.TextAlignment.Right,
                          )
                          .setPrintType(
                            StarXpandCommand.Printer.TextPrintType.Always,
                          ),
                      ),
                    )
                    .styleHorizontalPositionBy(10.0)
                    .actionPrintText(
                      "${refrigeration}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        9,
                        new StarXpandCommand.Printer.TextWidthParameter()
                          .setAlignment(
                            StarXpandCommand.Printer.TextAlignment.Right,
                          )
                          .setPrintType(
                            StarXpandCommand.Printer.TextPrintType.Always,
                          ),
                      ),
                    )
                    .styleHorizontalPositionBy(11.0)
                    .actionPrintText(
                      "${frozen}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        9,
                        new StarXpandCommand.Printer.TextWidthParameter()
                          .setAlignment(
                            StarXpandCommand.Printer.TextAlignment.Right,
                          )
                          .setPrintType(
                            StarXpandCommand.Printer.TextPrintType.Always,
                          ),
                      ),
                    ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(64.0, 12.0)
                    .setX(4.0)
                    .setY(46.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${note}",
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "order_number" : "SK687T",
    "total_quantity" : "1",
    "room_temperature" : "",
    "refrigeration" : "1",
    "frozen" : "",
    "remarks" : "（配達要注意商品）",
    "note" :  "たまご・トマト・パン・バナナ・ワレモノ・\\nお寿司\\n※要注意商品入っている場合は○を付けてます。"
}`,
    );
  }
}
